﻿using System;
using System.Threading;

namespace Implab.Parallels {
    /// <summary>
    /// Implements simple signalling logic using <see cref="Monitor.PulseAll(object)"/>.
    /// </summary>
    public class Signal {
        readonly object m_lock = new object();
        bool m_state;

        public void Set() {
            lock(m_lock) {
                m_state = true;
                Monitor.PulseAll(m_lock);
            }
        }

        public void Wait() {
            lock (m_lock)
                if (!m_state)
                    Monitor.Wait(m_lock);
        }

        public bool Wait(int timeout) {
            lock (m_lock)
                return m_state || Monitor.Wait(m_lock, timeout);
        }
    }
}

