using System;

namespace Implab.ServiceHost.Unity {
    public class FactoryActivator : FactoryAbstractRegistratrion {

        public Type FactoryType { get; set; }

        public string FactoryName { get; set; }

        public new Type RegistrationType { get; set; }

        public override void Visit(FactoryRegistrationBuilder builder) {
            base.Visit(builder);

            builder.GetType()
                .GetMethod(
                    nameof(FactoryRegistrationBuilder.SetFactoryDependency)
                    , new[] { typeof(string) }
                )
                .MakeGenericMethod(FactoryType, RegistrationType)
                .Invoke(builder, new[] { FactoryName });
        }

        public override Type GetRegistrationType(Func<string, Type> resolver) {
            return RegistrationType;
        }

    }
}