using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Xml.Serialization;
using Implab.Xml;
using Unity.Injection;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity {
    /// <summary>
    /// Базовый класс для формирования записей в контейнере, созволяет указать время жизни для записи
    /// </summary>
    public abstract class RegistrationBuilder {
        public Type RegistrationType {
            get;
            private set;
        }

        internal LifetimeManager Lifetime { get; set; }

        protected RegistrationBuilder(Type registrationType) {
            RegistrationType = registrationType;
        }

        internal void Visit(SingletonLifetimeElement simgletonLifetime) {
            Lifetime = new SingletonLifetimeManager();
        }

        internal void Visit(ContainerLifetimeElement containerLifetime) {
            Lifetime = new ContainerControlledLifetimeManager();
        }

        internal void Visit(HierarchicalLifetimeElement hierarchicalLifetime) {
            Lifetime = new HierarchicalLifetimeManager();
        }

        internal void Visist(ContextLifetimeElement contextLifetime) {
            Lifetime = new PerResolveLifetimeManager();
        }
    }
}