using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ValueElement : InstanceAbstractRegistration {
        
        [XmlAttribute("value")]
        public string Value { get; set; }

        [XmlText]
        public string Text { get; set; }

        string GetTextValue() {
            return string.IsNullOrEmpty(Value) ? Text : Value;
        }

        public string TypeName {
            get {
                return RegistrationType;
            }
        }

        public override void Visit(InstanceRegistrationBuilder builder) {
            base.Visit(builder);
            var parameter = new ValueParameterElement {
                Value = Value,
                Text = Text
            };
            parameter.Visit(builder.ValueBuilder);
        }
    }
}