using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class PropertyInjectionElement : AbstractMemberInjection {

        [XmlAttribute("name")]
        public string Name { get; set; }

        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        [XmlElement("array", typeof(ArrayParameterElement))]
        public InjectionParameterElement Value { get; set; }

        internal override void Visit(TypeRegistrationBuilder context) {
            context.Visit(this);
        }
    }
}