using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ConstructorInjectionElement : AbstractMemberInjection {
        
        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        [XmlElement("array", typeof(ArrayParameterElement))]
        public InjectionParameterElement[] Parameters { get; set; }

        internal override void Visit(TypeRegistrationBuilder context) {
            context.Visit(this);
        }
    }
}