using System;
using System.Xml.Serialization;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity {

    [XmlRoot("register", Namespace = Schema.ContainerConfigurationNamespace)]
    public class RegisterElement : TypeAbstractRegistration  {
        
        /// <summary>
        /// An optional type which is registered as a service in the container, must be assignable to <see cref="ProvidesType">.
        /// </summary>
        [XmlAttribute("mapTo")]
        public string MapToType { get; set; }


        [XmlElement("constructor", typeof(ConstructorInjectionElement))]
        [XmlElement("property", typeof(PropertyInjectionElement))]
        [XmlElement("method", typeof(MethodInjectionElement))]
        public AbstractMemberInjection[] Injectors { get; set; }

        public override Type GetImplementationType(Func<string, Type> resolver) {
            return string.IsNullOrEmpty(MapToType) ? null : resolver(MapToType);
        }

        public override void Visit(TypeRegistrationBuilder builder) {
            if(Injectors != null)
                foreach(var injector in Injectors)
                    injector.Visit(builder);
        }

        
    }
    
}