using System;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class SerializedElement : InstanceAbstractRegistration {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAttribute("serializedType")]
        public string SerializedType { get; set; }


        [XmlAnyElement]
        public XmlElement[] Content { get; set; }

        public override void Visit(InstanceRegistrationBuilder builder) {
            base.Visit(builder);

            var parameter = new SerializedParameterElement {
                TypeName = SerializedType,
                Location = Location,
                Content = Content
            };
            parameter.Visit(builder.ValueBuilder);
        }
    }
}