﻿using System.Threading;
using System;
using Implab.Diagnostics;
using System.Collections.Generic;
using System.Linq;

namespace Implab {
    public static class PromiseExtensions {

        public static IPromise Then(this IPromise that, Action fulfilled, Action<Exception> rejected) {
            var reaction = PromiseActionReaction.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Action fulfilled) {
            var reaction = PromiseActionReaction.Create(fulfilled, null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Action fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = PromiseActionReaction.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Func<IPromise> fulfilled, Action<Exception> rejected) {
            var reaction = PromiseActionReaction.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Func<IPromise> fulfilled) {
            var reaction = PromiseActionReaction.Create(fulfilled, null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then(this IPromise that, Func<IPromise> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = PromiseActionReaction.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Action<T> fulfilled, Action<Exception> rejected) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Action<T> fulfilled) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Action<T> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Func<T, IPromise> fulfilled, Action<Exception> rejected) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Func<T, IPromise> fulfilled) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Then<T>(this IPromise<T> that, Func<T, IPromise> fulfilled, Func<Exception, IPromise> rejected) {
            var reaction = PromiseActionReaction<T>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<Tout> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<Tout> fulfilled) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, (Func<Exception, Tout>)null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<Tout> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<IPromise<Tout>> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<IPromise<Tout>> fulfilled) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, (Func<Exception, Tout>)null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tout>(this IPromise that, Func<IPromise<Tout>> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = PromiseFuncReaction<Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, Tout> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, Tout> fulfilled) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, (Func<Exception, Tout>)null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, Tout> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, IPromise<Tout>> fulfilled, Func<Exception, Tout> rejected) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, IPromise<Tout>> fulfilled) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, (Func<Exception, Tout>)null, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise<Tout> Then<Tin, Tout>(this IPromise<Tin> that, Func<Tin, IPromise<Tout>> fulfilled, Func<Exception, IPromise<Tout>> rejected) {
            var reaction = PromiseFuncReaction<Tin, Tout>.Create(fulfilled, rejected, Promise.DefaultDispatcher);
            that.Then(reaction);
            return reaction.Promise;
        }

        public static IPromise Catch(this IPromise that, Action<Exception> rejected) {
            return Then(that, null, rejected);
        }

        public static IPromise Catch(this IPromise that, Func<Exception, IPromise> rejected) {
            return Then(that, null, rejected);
        }

        public static IPromise<Tout> Catch<Tout>(this IPromise that, Func<Exception, Tout> rejected) {
            return Then(that, (Func<Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tout>(this IPromise that, Func<Exception, IPromise<Tout>> rejected) {
            return Then(that, (Func<Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tin, Tout>(this IPromise<Tin> that, Func<Exception, Tout> rejected) {
            return Then(that, (Func<Tin, Tout>)null, rejected);
        }

        public static IPromise<Tout> Catch<Tin, Tout>(this IPromise<Tin> that, Func<Exception, IPromise<Tout>> rejected) {
            return Then(that, (Func<Tin, Tout>)null, rejected);
        }

        public static IPromise Finally(this IPromise that, Action final) {
            return Then(that, final, e => {
                final();
                throw e.Rethrow();
            });
        }

        public static IPromise Finally(this IPromise that, Func<IPromise> final) {
            return Then(that, final, e => {
                final();
                throw e.Rethrow();
            });
        }

        public static IPromise<T> Finally<T>(this IPromise<T> that, Action final) {
            return Then<T, T>(that, x => {
                final();
                return x;
            }, new Func<Exception, T>(e => {
                final();
                throw e.Rethrow();
            }));
        }

        public static IPromise<T> Finally<T>(this IPromise<T> that, Func<IPromise> final) {
            return Then<T, T>(that, x => {
                return final()
                    .Then(() => x);
            }, new Func<Exception, IPromise<T>>(e => {
                return final()
                    .Then(new Func<T>(() => {
                        throw e.Rethrow();
                    }));
            }));
        }

        public static PromiseAwaiter GetAwaiter(this IPromise that) {
            Safe.ArgumentNotNull(that, nameof(that));
            return new PromiseAwaiter(that);
        }

        public static PromiseAwaiter<T> GetAwaiter<T>(this IPromise<T> that) {
            Safe.ArgumentNotNull(that, nameof(that));
            return new PromiseAwaiter<T>(that);
        }

    }
}

