using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class ArrayParameterElement : InjectionParameterElement {

        [XmlAttribute("itemsType")]
        public string ItemsType { get; set; }

        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        public InjectionParameterElement[] Items { get; set; }

        public override void Visit(InjectionParameterBuilder builder) {
            builder.Visit(this);
        }
    }
}