using Implab.Xml;
using System.Collections.Generic;
using System.Xml;
using System.Xml.Schema;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    [XmlRoot("container", Namespace = Schema.ContainerConfigurationNamespace)]
    public class ContainerElement : IXmlSerializable {

        public List<ServiceElement> Registrations {get; set; } = new List<ServiceElement>();

        public XmlSchema GetSchema() {
            return null;
        }

        public void ReadXml(XmlReader reader) {
            while(reader.Read() && reader.NodeType != XmlNodeType.EndElement) {
                var registration = SerializationHelpers.Deserialize<ServiceElement>(reader);
                Registrations.Add(registration);
            }
        }

        public void WriteXml(XmlWriter writer) {
            throw new System.NotImplementedException();
        }
    }
}