using System;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {

    [XmlRoot("register", Namespace = Schema.ContainerConfigurationNamespace)]
    public class ServiceElement {
        /// <summary>
        /// An optional name for a registration in the container
        /// </summary>
        [XmlAttribute("name")]
        public string Name { get; set; }

        /// <summary>
        /// An optional type specification for the service registration, 
        /// must be assignable from the type specified by <see cref="ImplementedType"/>
        /// </summary>
        [XmlAttribute("provides")]
        public string ProvidesType { get; set; }

        /// <summary>
        /// The type which is registered as a service in the container.
        /// </summary>
        [XmlAttribute("type")]
        public string ImplementedType { get; set; }
    }
    
}