using System;
using System.Threading;

namespace Implab.Parallels {
	/// <summary>
	/// Класс для распаралеливания задач.
	/// </summary>
	/// <remarks>
	/// Используя данный класс и лямда выражения можно распараллелить
	/// вычисления, для этого используется концепция обещаний.
	/// </remarks>
	public static class AsyncPool {

		public static Promise<T> Invoke<T>(Func<T> func) {
			var p = new Promise<T>();

			ThreadPool.QueueUserWorkItem(param => {
				try {
					p.Resolve(func());
				} catch(Exception e) {
					p.Reject(e);
				}
			});

			return p;
		}
	}
}
