﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab
{
    public interface IPromise
    {
        /// <summary>
        /// Check whereather the promise has no more than one dependent promise.
        /// </summary>
        bool IsExclusive
        {
            get;
        }

        /// <summary>
        /// The current state of the promise.
        /// </summary>
        PromiseState State
        {
            get;
        }

        /// <summary>
        /// Tries to cancel the the complete chain of promises.
        /// </summary>
        /// <returns><c>true</c> -  if the promise has been cancelled, otherwise the promise will be resolved (or resolved already).</returns>
        bool Cancel();

        /// <summary>
        /// Registers handler for the case when the promise is cencelled. If the promise already cancelled the
        /// handler will be invoked immediatelly.
        /// </summary>
        /// <param name="handler">The handler</param>
        void HandleCancelled(Action handler);
    }
}
