﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace Implab {
    public class SyncContextPromise : Promise {
        readonly SynchronizationContext m_context;

        public SyncContextPromise(SynchronizationContext context) {
            Safe.ArgumentNotNull(context, "context");

            m_context = context;
        }

        protected override void SignalHandler(HandlerDescriptor handler, int signal) {
            m_context.Post(x => base.SignalHandler(handler, signal), null);
        }
    }
}
