﻿using System;
using System.Threading;
using System.Threading.Tasks;

namespace Implab.Components {
    /// <summary>
    /// Interface for the component which performs a long running task.
    /// </summary>
    /// <remarks>
    /// The access to the runnable component should be sequential, the
    /// componet should support asynchronous completion of the initiated
    /// operation but operations itself must be initiated sequentially.
    /// </remarks>
    public interface IRunnable {
        /// <summary>
        /// Starts this instance
        /// </summary>
        /// <remarks>
        /// This operation is cancellable and it's expected to move to
        /// the failed state or just ignore the cancellation request,
        /// </remarks>
        void Start(CancellationToken ct);

        /// <summary>
        /// Stops this instance and releases all resources, after the
        /// instance is stopped it is moved to Disposed state and
        /// can't be reused.
        /// </summary>
        /// <remarks>
        /// If the componet was in the starting state the pending operation
        /// will be requested to cancel. The stop operatin will be
        /// performed only if the component in the running state.
        /// </remarks>
        void Stop(CancellationToken ct);

        /// <summary>
        /// The result of the last started operation. This property reflects
        /// only the result of the last started operation and therefore should
        /// change only if a new operation is initiated.
        /// </summary>
        Task Completion { get; }

        /// <summary>
        /// Current state of the componenet
        /// </summary>
        ExecutionState State { get; }

        /// <summary>
        /// Event to monitor the state of the component.
        /// </summary>
        event EventHandler<StateChangeEventArgs> StateChanged;

        /// <summary>
        /// The last error
        /// </summary>
        Exception LastError { get; }
    }
}

