﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    public static class Trace<T> {

        readonly static TraceSource _traceSource = new TraceSource(typeof(T).Name);
        
        public static TraceSource TraceSource {
            get { return _traceSource; }
        }
        
        /// <summary>
        /// Starts the logical operation nested to the current operation nested to the current one.
        /// </summary>
        [Conditional("TRACE")]
        public static void StartLogicalOperation() {
            Trace.CorrelationManager.StartLogicalOperation();

        }

        /// <summary>
        /// Starts the logical operation with the specified name, this name is usefull in logs.
        /// </summary>
        /// <param name="name">Name.</param>
        [Conditional("TRACE")]
        public static void StartLogicalOperation(string name) {
            Trace.CorrelationManager.StartLogicalOperation();
        }

        /// <summary>
        /// Ends the logical operation and restores the previous one.
        /// </summary>
        [Conditional("TRACE")]
        public static void StopLogicalOperation() {
            Trace.CorrelationManager.StopLogicalOperation();
        }

        /// <summary>
        /// Writes an informational message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void Log(string format, params object[] arguments) {
            TraceSource.TraceEvent(TraceEventType.Information, 1, format, arguments);
        }

        /// <summary>
        /// Writes a warning message.
        /// </summary>
        /// <param name="format">Format.</param>
        /// <param name="arguments">Arguments.</param>
        [Conditional("TRACE")]
        public static void Warn(string format, params object[] arguments) {
            TraceSource.TraceEvent(TraceEventType.Warning, 1, format, arguments);
        }

        [Conditional("TRACE")]
        public static void Error(string format, params object[] arguments) {
            TraceSource.TraceEvent(TraceEventType.Error, 1, format, arguments);
        }

        [Conditional("TRACE")]
        public static void Error(Exception err) {
            TraceSource.TraceData(TraceEventType.Error, 1, err);
        }
    }
}
