﻿using System;

namespace Implab {
    public class ActionChainTask<T> : ActionChainTaskBase, IDeferred<T> {
        readonly Func<T, IPromise> m_task;

        public ActionChainTask(Func<T, IPromise> task, Func<Exception, IPromise> error, Func<Exception, IPromise> cancel) : base(error,cancel) {
            m_task = task;
        }

        public void Resolve(T value) {
            if (m_task != null && LockCancelation()) {
                try {
                    Observe(m_task(value));
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }

    }
}

