﻿using System;

namespace Implab {
    public class FuncChainTask<TArg,TResult> : FuncChainTaskBase<TResult>, IDeferred<TArg> {
        readonly Func<TArg, IPromise<TResult>> m_task;

        public FuncChainTask(Func<TArg, IPromise<TResult>> task, Func<Exception, IPromise<TResult>> error, Func<Exception, IPromise<TResult>> cancel) : base(error, cancel){
            m_task = task;
        }

        public void Resolve(TArg value) {
            if (m_task != null && LockCancelation()) {
                try {
                    Observe(m_task(value));
                } catch (Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}