﻿using System;
using System.Threading;

namespace Implab {
    public class FuncTask<T> : FuncTaskBase<T>, IDeferred {
        readonly Func<T> m_task;

        public FuncTask(Func<T> task, Func<Exception, T> error, Func<Exception, T> cancel) : base(error,cancel) {
            m_task = task;
        }

        public void Resolve() {
            if (m_task != null && LockCancelation()) {
                try {
                    SetResult(m_task());
                } catch(Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}

