﻿using Implab.Diagnostics;
using Implab.Formats.Json;
using Implab.Parallels;
using Implab.Xml;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.Playground {
    using System.Diagnostics;
    using static Trace<Program>;

    public class Program {

        static void Main(string[] args) {
            var listener = new SimpleTraceListener(Console.Out);

            var source = Trace<Program>.TraceSource;
            source.Switch.Level = SourceLevels.All;

            source.Listeners.Add(listener);

            var t = Environment.TickCount;

            Main().Wait();

            Console.WriteLine($"Done: {Environment.TickCount - t} ms");
            Console.ReadKey();
        }

        static async Task Main() {
            using (LogicalOperation(nameof(Main))) {
                Log("Start");
                await SomeAsync();
                Log("End");
            }
        }

        static async Task SomeAsync() {
            using (LogicalOperation(nameof(SomeAsync))) {
                Log("Do prepare");
                await Task.Yield();
                Log("Yield");
            }
        }
    }
}
