using System;
using Unity.Injection;

namespace Implab.ServiceHost.Unity {

    public class InjectionValueContext {

        readonly TypeResolver m_resolver;

        public Type AcceptsType { get; private set; }

        public object Value { get; set; }

        internal InjectionValueContext(TypeResolver resolver, Type acceptsType) {
            m_resolver = resolver;
            AcceptsType = acceptsType;
        }

        public Type ResolveType(string typeSpec) {
            if (string.IsNullOrEmpty(typeSpec)) {
                if (AcceptsType == null)
                    throw new Exception("The type must be specified");
                return AcceptsType;
            }
            return m_resolver.Resolve(typeSpec);
        }

        public void Visit(ITextValue value) {

        }

        public void Visit(ISerializedValue value) {

        }

        public void Visit(IDependencyReference value) {
            Value = new ResolvedParameter()
        }

    }
}