using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ConstructorInjectionElement : AbstractInjectionElement {
        
        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        public InjectionParameterElement[] Parameters { get; set; }

        internal override void Visit(TypeRegistrationContext context) {
            context.Visit(this);
        }
    }
}