using System;
using System.Xml;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity
{
    public class SerializedElement : AbstractRegistration {
        [XmlAttribute("href")]
        public string Location { get; set; }

        [XmlAttribute("serializedType")]
        public string SerializedType { get; set; }


        [XmlAnyElement]
        public XmlElement[] Content { get; set; }
        
        public override void Visit(ContainerContext context) {
            context.Visit(this);
        }

        public virtual Type ResolveSerializedType(ContainerContext context) {
            if(string.IsNullOrEmpty(SerializedType))
                return ResolveRegistrationType(context);
            return context.Resolve(SerializedType);
        }

        public virtual object GetValue(ContainerContext context) {
            var type = ResolveRegistrationType(context);
            if (Content == null || Content.Length == 0)
                return Safe.CreateDefaultValue(type);

            var serializer = new XmlSerializer(type);
            using(var reader = Content[0].CreateNavigator().ReadSubtree())
                return serializer.Deserialize(reader);
        }
    }
}