using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class MethodInjectionElement : AbstractInjectionElement {

        [XmlAttribute("name")]
        public string Name { get; set; }

        [XmlElement("dependency", typeof(DependencyParameterElement))]
        [XmlElement("value", typeof(ValueParameterElement))]
        [XmlElement("serialized", typeof(SerializedParameterElement))]
        [XmlElement("default", typeof(DefaultParameterElement))]
        public InjectionParameterElement[] Parameters { get; set; }

        internal override void Visit(RegistrationContext context) {
            context.Visit(this);
        }
    }
}