﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Diagnostics {
    public class LogicalOperation {
        readonly LogicalOperation m_parent;
        readonly string m_name;
        readonly int m_level;
        readonly int m_timestamp;

        public LogicalOperation()
            : this(null, null) {
        }

        public LogicalOperation(string name, LogicalOperation parent) {
            m_name = name ?? String.Empty;
            m_parent = parent;

            m_level = parent == null ? 0 : parent.Level + 1;
            m_timestamp = Environment.TickCount;
        }

        public int Duration {
            get {
                var dt = Environment.TickCount - m_timestamp;
                return dt < 0 ? int.MaxValue + dt : dt; // handle overflow
            }
        }

        public LogicalOperation Parent {
            get {
                return m_parent;
            }
        }

        public int Level {
            get { return m_level; }
        }

        public string Name {
            get { return m_name; }
        }
    }
}
