﻿using System;

namespace Implab.Diagnostics {
    public class LogEventArgs : EventArgs {
        public object Channel {
            get;
            private set;
        }
        public int ThreadId {
            get;
            private set;
        }
        public LogicalOperation Operation {
            get;
            private set;
        }
        public int OperationTimeOffset {
            get;
            private set;
        }
        public LogEventArgs(object channel, int threadId, LogicalOperation operation, int timeOffset) {
            Channel = channel;
            ThreadId = threadId;
            Operation = operation;
            OperationTimeOffset = timeOffset;
        }
    }
}

