﻿using System;

namespace Implab.Automaton {
    public class AutomatonTransition : IEquatable<AutomatonTransition> {
        public readonly int s1;
        public readonly int s2;
        public readonly int edge;

        public AutomatonTransition(int s1, int s2, int edge) {
            this.s1 = s1;
            this.s2 = s2;
            this.edge = edge;
        }


        #region IEquatable implementation
        public bool Equals(AutomatonTransition other) {
            return other.s1 == s1 && other.s2 == s2 && other.edge == edge ;
        }
        #endregion

        public override bool Equals(object obj) {
            if (obj is AutomatonTransition)
                return Equals((AutomatonTransition)obj);
            return base.Equals(obj);
        }

        public override int GetHashCode() {
            return s1 + s2 + edge;
        }

        public static bool operator == (AutomatonTransition rv, AutomatonTransition lv) {
            return rv.Equals(lv);
        }

        public static bool operator !=(AutomatonTransition rv, AutomatonTransition lv) {
            return rv.Equals(lv);
        }
    }
}

