﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab
{
    public interface IPromise<T>: IPromiseBase
    {

        T Join();

        T Join(int timeout);

        IPromise<T> Then(ResultHandler<T> success, ErrorHandler error);
        IPromise<T> Then(ResultHandler<T> success, ErrorHandler<T> error);
        IPromise<T> Then(ResultHandler<T> success);
        IPromise<T> Error(ErrorHandler error);
        IPromise<T> Error(ErrorHandler<T> error);

        IPromise<T2> Map<T2>(ResultMapper<T,T2> mapper, ErrorHandler error);
        IPromise<T2> Map<T2>(ResultMapper<T, T2> mapper);

        IPromise<T2> Chain<T2>(ChainedOperation<T, T2> chained, ErrorHandler error);
        IPromise<T2> Chain<T2>(ChainedOperation<T, T2> chained);

        IPromise<T> Cancelled(Action handler);
        IPromise<T> Finally(Action handler);
        IPromise<T> Anyway(Action handler);

    }
}
