﻿using System;

namespace Implab.Components {
    public interface IRunnable {
        /// <summary>
        /// Starts this instance.
        /// </summary>
        IPromise Start();

        /// <summary>
        /// Stops this instance. After the instance is stopped it can't be started again, stopping should be treated as gracefull and async dispose.
        /// </summary>
        IPromise Stop();

        ExecutionState State { get; }

        event EventHandler<StateChangeEventArgs> StateChanged;

        Exception LastError { get; }
    }
}

