﻿using System;

namespace Implab {
    public class FuncChainTaskBase<TResult> : AbstractTask<TResult> {
        readonly Func<Exception, IPromise<TResult>> m_error;
        readonly Func<Exception, IPromise<TResult>> m_cancel;

        protected FuncChainTaskBase( Func<Exception, IPromise<TResult>> error, Func<Exception, IPromise<TResult>> cancel, bool autoCancellable) {
            m_error = error;
            m_cancel = cancel;
            if (autoCancellable)
                CancellationRequested(CancelOperation);
        }

        public void Reject(Exception error) {
            if (LockCancelation())
                HandleErrorInternal(error);
        }

        public override void CancelOperation(Exception reason) {
            if (LockCancelation())
                HandleCancelInternal(reason);
        }

        protected void HandleErrorInternal(Exception error) {
            if (m_error != null) {
                try {
                    var p = m_error(error);
                    p.On(SetResult, SetErrorInternal, SetCancelledInternal);
                    CancellationRequested(p.Cancel);
                } catch(Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetErrorInternal(error);
            }
        }

        protected void HandleCancelInternal(Exception reason) {
            if (m_cancel != null) {
                try {
                    var p = m_cancel(reason);
                    p.On(SetResult, HandleErrorInternal, SetCancelledInternal);
                    CancellationRequested(p.Cancel);
                } catch (Exception err) {
                    SetErrorInternal(err);
                }
            } else {
                SetCancelledInternal(reason);
            }
        }
    }
}

