﻿using System;

namespace Implab {
    public class FuncTask<TArg, TResult> : FuncTaskBase<TResult>, IDeferred<TArg> {
        readonly Func<TArg, TResult> m_task;

        public FuncTask(Func<TArg, TResult> task, Func<Exception, TResult> error,Func<Exception, TResult> cancel, bool autoCancellable) :  base(error,cancel, autoCancellable) {
            m_task = task;
        }

        public void Resolve(TArg value) {
            if (m_task != null && LockCancelation()) {
                try {
                    SetResult(m_task(value));
                } catch (Exception err) {
                    HandleErrorInternal(err);
                }
            }
        }
    }
}

