﻿using Implab;
using Implab.Parallels;
using Implab.Diagnostics;
using System.Threading;

namespace MonoPlay {
    class MainClass {


        public static void Main(string[] args) {
            var pool = new WorkerPool(10);

            var listerner = new ConsoleTraceListener();
            listerner.Subscribe<TraceEvent>();

            TraceLog.StartLogicalOperation("Main");


            var d = pool.Invoke(() => {
                TraceLog.StartLogicalOperation("Worker");
                Thread.Sleep(100);
                TraceLog.TraceInformation("worker done");
                TraceLog.EndLogicalOperation();
            });

            var op = TraceContext.Instance.CurrentOperation;
            ThreadPool.QueueUserWorkItem((o) => {
                TraceContext.Instance.EnterLogicalOperation(op, false);
                TraceLog.StartLogicalOperation("Thread");
                Thread.Sleep(100);
                TraceLog.TraceInformation("thread done");
                TraceLog.EndLogicalOperation();
            });

            TraceLog.TraceInformation("main done");
            TraceLog.EndLogicalOperation();

            d.Join();



        }

    }
}
