using System.IO;
using Unity;

namespace Implab.ServiceHost.Unity
{
    public static class UnityContainerExtensions
    {
        public static IUnityContainer LoadXmlConfiguration(this IUnityContainer container, string file, ContainerConfigurationSchema schema) {
            Safe.ArgumentNotNull(container, nameof(container));
            var builder = new ContainerBuilder(container,schema);
            builder.LoadConfig(file);
            return builder.Container;
        }

        public static IUnityContainer LoadXmlConfiguration(this IUnityContainer container, Stream stream, ContainerConfigurationSchema schema) {
            Safe.ArgumentNotNull(container, nameof(container));
            Safe.ArgumentNotNull(stream, nameof(stream));
            
            if (schema == null)
                schema = ContainerConfigurationSchema.Default;

            var builder = new ContainerBuilder(container,schema);
            var config = (ContainerElement)schema.Serializer.Deserialize(stream);
            if (config.Items != null) {
                foreach(var item in config.Items)
                    item?.Visit(builder);
            }

            return builder.Container;
        }

        public static IUnityContainer LoadXmlConfiguration(this IUnityContainer container, Stream stream) {
            return LoadXmlConfiguration(container, stream, ContainerConfigurationSchema.Default);
        }

        public static IUnityContainer LoadXmlConfiguration(this IUnityContainer container, string file) {
            return LoadXmlConfiguration(container, file, ContainerConfigurationSchema.Default);
        }
    }
}