﻿using System;
using System.IO;
using System.Text;

namespace Implab.Diagnostics {
    public class TextFileListener: TextListenerBase {
        readonly TextWriter m_textWriter;

        public TextFileListener(string fileName, bool global)
            : base(global) {
            m_textWriter = File.CreateText(fileName);

            m_textWriter.WriteLine("LOG {0}", DateTime.Now);
            Register(this);
        }

        protected override void WriteEntry(LogEventArgs args, EventText text, string channel) {
            var msg = new StringBuilder();
            for (int i = 0; i < text.indent; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]:{1}: {2}", args.ThreadId, channel, text.content);

            lock (m_textWriter) {
                if (!IsDisposed) {
                    // тут гарантировано еще не освобожден m_textWriter
                    m_textWriter.WriteLine(msg);
                    m_textWriter.Flush();
                }
            }
        }

        
        protected override void Dispose(bool disposing) {
            base.Dispose(disposing);
            if (disposing) {
                // IsDisposed = true
                lock (m_textWriter) {
                    Safe.Dispose(m_textWriter);
                }
            }
        }

        
    }
}
