﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab.Diagnostics {
    public class ConsoleTraceListener: TextListenerBase {

        static readonly object _consoleLock = new object();

        public ConsoleTraceListener()
            : base(true) {

        }

        public ConsoleTraceListener(bool global)
            : base(global) {

        }

        protected override void WriteEntry(LogEventArgs args, EventText text, string channel) {
            var msg = new StringBuilder();

            for (int i = 0; i < text.indent; i++)
                msg.Append("  ");
            msg.AppendFormat("[{0}]:{1}: {2}", args.ThreadId, channel, text.content);

            lock (_consoleLock) {
                //Console.ForegroundColor = (ConsoleColor)(args.ThreadId % 15 + 1);
                Console.WriteLine(msg);
            }
        }
    }
}
