﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Implab {
    /// <summary>
    /// Компоненты являются состовными объектами, имеют детерминированный период жизни, автоматически освобождают ресурсы входящие в них.
    /// </summary>
    /// <remarks>Компонента управляет временем жизни включенных в нее компонент</remarks>
    public class Component: Disposable {
        LinkedList<IDisposable> m_components = new LinkedList<IDisposable>();

        /// <summary>
        /// Коллекция компонент, из которых состоит текущая компонента.
        /// </summary>
        public ICollection<IDisposable> Components {
            get {
                AssertNotDisposed();
                return m_components;
            }
        }

        /// <summary>
        /// Освобождает компоненты, входящие в состав текущей компоненты.
        /// </summary>
        /// <param name="disposing">Признак того, что происходит освобождение ресурсов.</param>
        protected override void Dispose(bool disposing) {
            if (disposing) {
                foreach (var item in m_components)
                    item.Dispose();
                m_components.Clear();
            }
            base.Dispose(disposing);
        }
    }
}