﻿using System;

namespace Implab {

    [Serializable]
    public class TransientPromiseException : Exception {
        /// <summary>
        /// Initializes a new instance of the <see cref="PromiseFailedException"/> class.
        /// </summary>
        /// <param name="inner">The exception that is the cause of the current exception.</param>
        public TransientPromiseException(Exception inner) : base("The preceding promise has failed", inner) {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PromiseFailedException"/> class
        /// </summary>
        /// <param name="message">A <see cref="T:System.String"/> that describes the exception. </param>
        /// <param name="inner">The exception that is the cause of the current exception. </param>
        public TransientPromiseException(string message, Exception inner)
            : base(message, inner) {
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="PromiseFailedException"/> class
        /// </summary>
        /// <param name="context">The contextual information about the source or destination.</param>
        /// <param name="info">The object that holds the serialized object data.</param>
        protected TransientPromiseException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context)
            : base(info, context) {
        }
    }
}

