﻿using System.Collections.Generic;
using System.Linq;
using Implab.Automaton;

namespace Implab.Formats {
    public class ByteAlphabet : IndexedAlphabetBase<byte> {
        public ByteAlphabet() : base(byte.MaxValue + 1){
        }

        #region implemented abstract members of IndexedAlphabetBase

        public override int GetSymbolIndex(byte symbol) {
            return (int)symbol;
        }

        public IEnumerable<byte> InputSymbols {
            get {
                return Enumerable.Range(byte.MinValue, byte.MaxValue).Cast<byte>();
            }
        }

        #endregion
    }
}

