﻿namespace Implab.Automaton {
    public struct DFAStateDescriptor {
        public readonly bool final;
        public readonly int[] transitions;


        public DFAStateDescriptor(int[] transitions, bool final) {
            this.transitions = transitions;
            this.final = final;
        }

        public DFAStateDescriptor(int[] transitions) : this(transitions, false) {
        }

        public DFAStateDescriptor(int size, bool final) {
            Safe.ArgumentInRange(size, 0, int.MaxValue, "size");

            this.final = final;

            transitions = new int[size];

            for (int i = 0; i < size; i++)
                transitions[i] = DFAConst.UNREACHABLE_STATE;
        }
    }
}
