﻿using Implab;

namespace Implab.Automaton.RegularExpressions {
    /// <summary>
    /// Конечный символ расширенного регулярного выражения, при построении ДКА
    /// используется для определения конечных состояний.
    /// </summary>
    public class EndToken<TTag>: Token<TTag> {

        TTag m_tag;

        public EndToken(TTag tag) {
            m_tag = tag;
        }

        public EndToken()
            : this(default(TTag)) {
        }

        public TTag Tag {
            get { return m_tag; }
        }
        
        public override void Accept(IVisitor<TTag> visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }
        public override string ToString() {
            return "#";
        }
    }
}
