﻿using Implab;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Implab.Automaton.RegularExpressions {
    /// <summary>
    /// Замыкание выражения с 0 и более повторов.
    /// </summary>
    public class StarToken<TTag>: Token<TTag> {

        Token<TTag> m_token;

        public Token<TTag> Token {
            get { return m_token; }
        }

        public StarToken(Token<TTag> token) {
            Safe.ArgumentNotNull(token, "token");
            m_token = token;
        }

        public override void Accept(IVisitor<TTag> visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }

        public override string ToString() {
            return String.Format("({0})*", Token);
        }
    }
}
