﻿using System;

namespace Implab.Automaton.RegularExpressions {
    public class AltToken<TTag>: BinaryToken<TTag> {
        public AltToken(Token<TTag> left, Token<TTag> right)
            : base(left, right) {
        }

        public override void Accept(IVisitor<TTag> visitor) {
            Safe.ArgumentNotNull(visitor, "visitor");
            visitor.Visit(this);
        }
        public override string ToString() {
            return String.Format(Right is BinaryToken<TTag> ? "{0}|({1})" : "{0}|{1}", Left, Right);
        }
    }
}
