﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Implab {
    public interface IPromise: ICancellable {

        /// <summary>
        /// Тип результата, получаемого через данное обещание.
        /// </summary>
        Type PromiseType { get; }

        /// <summary>
        /// Обещание является выполненым, либо успешно, либо с ошибкой, либо отменено.
        /// </summary>
        bool IsResolved { get; }

        /// <summary>
        /// Обещание было отменено.
        /// </summary>
        bool IsCancelled { get; }

        /// <summary>
        /// Исключение возникшее в результате выполнения обещания, либо причина отмены.
        /// </summary>
        Exception Error { get; }

        /// <summary>
        /// Adds specified listeners to the current promise.
        /// </summary>
        /// <param name="success">The handler called on the successful promise completion.</param>
        /// <param name="error">The handler is called if an error while completing the promise occurred.</param>
        /// <param name="cancel">The handler is called in case of promise cancellation.</param>
        /// <returns>The current promise.</returns>
        IPromise On(Action success, Action<Exception> error, Action<Exception> cancel);
        IPromise On(Action success, Action<Exception> error);
        IPromise On(Action success);

        /// <summary>
        /// Adds specified listeners to the current promise.
        /// </summary>
        /// <param name="handler">The handler called on the specified events.</param>
        /// <param name = "events">The combination of flags denoting the events for which the
        /// handler shoud be called.</param>
        /// <returns>The current promise.</returns>
        IPromise On(Action handler, PromiseEventType events);

        /// <summary>
        /// Преобразует результат обещания к заданному типу и возвращает новое обещание.
        /// </summary>
        IPromise<T> Cast<T>();

        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        void Join();
        /// <summary>
        /// Синхронизирует текущий поток с обещанием.
        /// </summary>
        /// <param name="timeout">Время ожидания, по его истечению возникнет исключение.</param>
        /// <exception cref="TimeoutException">Превышено время ожидания.</exception>
        void Join(int timeout);

    }
}
