using System;
using System.Xml.Serialization;
using Unity.Lifetime;
using Unity.Registration;

namespace Implab.ServiceHost.Unity
{
    /// <summary>
    /// Базовая информаци о регистрации в контейнере: тип, имя и время жизни
    /// </summary>
    public abstract class AbstractRegistration : AbstractContainerItem {

        /// <summary>
        /// An optional name for a registration in the container
        /// </summary>
        [XmlAttribute("name")]
        public string Name {
            get; set;
        }

        [XmlElement("signleton", typeof(SingletonLifetimeElement))]
        [XmlElement("context", typeof(ContextLifetimeElement))]
        [XmlElement("container", typeof(ContainerLifetimeElement))]
        [XmlElement("hierarchy", typeof(HierarchicalLifetimeElement))]
        public LifetimeElement Lifetime {get; set;}

        /// <summary>
        /// A type specification for the service registration, 
        /// </summary>
        [XmlAttribute("type")]
        public string RegistrationType { get; set; }

        public virtual Type GetRegistrationType(Func<string,Type> resolver) {
            return resolver(RegistrationType);
        }

        public virtual void Visit(RegistrationBuilder builder) {
            Lifetime?.Visit(builder);
        }

    }
}