using System.ComponentModel;
using System.Xml.Serialization;

namespace Implab.ServiceHost.Unity {
    public class ValueParameterElement : InjectionParameterElement {
        [XmlAttribute("value")]
        public string Value { get; set; }

        [XmlText]
        public string Text { get; set; }

        string GetTextValue() {
            return string.IsNullOrEmpty(Value) ? Text : Value;
        }

        public override void Visit(InjectionValueBuilder builder) {
            var type = builder.ResolveInjectedValueType(TypeName);
            builder.SetValue(type, TypeDescriptor.GetConverter(type).ConvertFromString(GetTextValue()));
        }
    }
}