using System;
using Implab.Components;
using Unity;
using Unity.Injection;
using Unity.Registration;

namespace Implab.ServiceHost.Unity
{
    public class FactoryRegistrationBuilder : RegistrationBuilder {
        
        internal InjectionMember Factory { get; private set; }

        internal FactoryRegistrationBuilder(Type registrationType) : base(registrationType) {
        }

        public void SetFactoryDelegate(Delegate factory) {
            Safe.ArgumentNotNull(factory, nameof(factory));

            Factory = new DelegateInjectionFactory(factory);
        }

        public void SetFactoryDependency<T>(string dependencyName, Func<T, object> factory) {
            Safe.ArgumentNotNull(factory, nameof(factory));

            Factory = new InjectionFactory((c,t,name) => {
                var backend = c.Resolve<T>(dependencyName);
                return factory(backend);
            });
        }

        public void SetFactoryDependency<TFac, TObj>(string dependencyName) where TFac : IFactory<TObj> {
            
            Factory = new InjectionFactory(c => c.Resolve<TFac>(dependencyName).Create());
        }
    }
}