﻿using System;
using Implab.Components;
using Implab.Automaton.RegularExpressions;
using System.Diagnostics;
using Implab.Automaton;

namespace Implab.Formats {
    public abstract class TextScanner<TTag> : Disposable {

        int m_maxSymbol;
        int[] m_symbolMap;

        readonly char[] m_buffer;
        int m_bufferOffset;
        int m_bufferSize;
        int m_tokenLength;

        TTag[] m_tags;

        protected bool ReadTokenInternal(DFAStateDescriptor<TTag>[] dfa, int state) {
            Debug.Assert(dfa != null);

            do {
                for (var pos = m_bufferOffset; pos < m_bufferSize; pos++) {
                    var ch = m_buffer[pos];
                    state = dfa[state].transitions[m_symbolMap[ch > m_maxSymbol ? m_maxSymbol : ch]];
                    if (state == DFAConst.UNREACHABLE_STATE)
                        break;
                }
            } while (Feed());

            if (dfa[state].final) {

            }

        }

        bool Feed() {

        }

        protected abstract int Read(char[] buffer, int offset, int size);

        protected TTag[] Tags {
            get {
                return m_tags; 
            }
        }

         
    }
}

