﻿using Implab;
using System;

namespace Implab.Parsing {
    public class EDFADefinition<T> : DFADefinitionBase where T : struct, IConvertible {
        readonly EnumAlphabet<T> m_alphabet;

        public EnumAlphabet<T> Alphabet { 
            get { return m_alphabet; }
        }

        public EDFADefinition(EnumAlphabet<T> alphabet) {
            Safe.ArgumentNotNull(alphabet, "alphabet");
            m_alphabet = alphabet;
        }

        public override int AlphabetSize {
            get { return m_alphabet.Count; }
        }

        public EDFADefinition<T> Optimize() {
            var optimized = new EDFADefinition<T>(new EnumAlphabet<T>());
            Optimize(optimized, m_alphabet, optimized.Alphabet);

            return optimized;
        }

        public void PrintDFA() {
            PrintDFA(m_alphabet);
        }
    }
}
