﻿using System;
using Implab.Components;

namespace Implab.Formats {
    public abstract class TextScanner<TTag> : Disposable {

        readonly int[] m_buffer;
        int m_bufferOffset;
        int m_dataLength;
        int m_tokenLength;

        TTag[] m_tags;

        BufferScanner<TTag> m_scanner;

        protected bool ReadTokenInternal() {
            if (EOF)
                return false;
            
            // create a new scanner from template (scanners are value types)
            var inst = m_scanner;

            m_tokenLength = 0;

            while (inst.Scan(m_buffer, m_bufferOffset, m_dataLength)) {
                m_tokenLength += m_dataLength;

                var actual = Read(m_buffer, 0, m_buffer.Length);
                    
                m_bufferOffset = 0;
                m_dataLength = actual;

                if (actual == 0) {
                    inst.Eof();
                    break;
                }
            }

            var len = inst.Position - m_bufferOffset;
            m_tokenLength += len;
            m_dataLength -= len;
            m_bufferOffset = inst.Position;

            // save result;
        
            m_tags = inst.GetTokenTags();
        }

        protected abstract int Read(int[] buffer, int offset, int size);

        protected TTag[] Tags {
            get {
                return m_tags; 
            }
        }

        public abstract bool EOF { get; }
 
    }
}

